/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "..\x86emu.h"
//this file for emulating string opcodes (movs,lods,stos,cmps,scas)

//LODS
int op_lods(Thread& thread,ins_disasm* s){
    int rep=1;     //for repeat instructions
    if (s->hde.flags & F_PREFIX_REP){
       rep=thread.Exx[1];            //ecx
       thread.Exx[1]=0;              //set it to zero
    };
    //now we will loop the read instruction
    for (int i=0;i< rep;i++){
        //one byte
        dword* ptr=(dword*)thread.mem->read_virtual_mem(thread.Exx[6]);  //esi
        if (s->opcode->substr(0,s->opcode->size())=="lodsb"){
           thread.Exx[0]=(thread.Exx[0] &0xFFFFFF00)+ (*ptr &0xFF); 
           thread.Exx[6]+=1;                                                
        }else if (s->opcode->substr(0,s->opcode->size())=="lodsd" && (s->hde.flags & F_PREFIX_66)){
           thread.Exx[0]=(thread.Exx[0] &0xFFFF0000)+ (*ptr & 0xFFFF);  
           thread.Exx[6]+=2;
        }else if (s->opcode->substr(0,s->opcode->size())=="lodsd" && !(s->hde.flags & F_PREFIX_66)){
           thread.Exx[0]=*ptr;        
           thread.Exx[6]+=4;                                           
        };
    };
};
//-----------------------------------------------------------------------------------------------------------------
//STOS
int op_stos(Thread& thread,ins_disasm* s){
    int rep=1;     //for repeat instructions
    if (s->hde.flags & F_PREFIX_REP){
       rep=thread.Exx[1];            //ecx
       thread.Exx[1]=0;              //set it to zero
    };
    //now we will loop the read instruction
    for (int i=0;i< rep;i++){
        //one byte
        if (s->opcode->substr(0,s->opcode->size())=="stosb"){
           thread.mem->write_virtual_mem(thread.Exx[7],1,(char*)&thread.Exx[0]);
           thread.Exx[7]+=1;                                                
        }else if (s->opcode->substr(0,s->opcode->size())=="stosd" && (s->hde.flags & F_PREFIX_66)){
           thread.mem->write_virtual_mem(thread.Exx[7],2,(char*)&thread.Exx[0]);
           thread.Exx[7]+=2;
        }else if (s->opcode->substr(0,s->opcode->size())=="stosd" && !(s->hde.flags & F_PREFIX_66)){
           thread.mem->write_virtual_mem(thread.Exx[7],4,(char*)&thread.Exx[0]);
           thread.Exx[7]+=4;                                           
        };
    };
};
//-----------------------------------------------------------------------------------------------------------------
//MOVS
int op_movs(Thread& thread,ins_disasm* s){
    int rep=1;     //for repeat instructions
    if (s->hde.flags & F_PREFIX_REP){
       rep=thread.Exx[1];            //ecx
       thread.Exx[1]=0;              //set it to zero
    };
    //now we will loop the read instruction
    for (int i=0;i< rep;i++){
        //one byte
         dword* ptr=(dword*)thread.mem->read_virtual_mem(thread.Exx[6]);  //esi
        if (s->opcode->substr(0,s->opcode->size())=="movsb"){
           char n=(char)(*ptr &0xFF); 
           thread.mem->write_virtual_mem(thread.Exx[7],1,(char*)&n);
           thread.Exx[6]+=1;
           thread.Exx[7]+=1;
        }else if (s->opcode->substr(0,s->opcode->size())=="movsd" && (s->hde.flags & F_PREFIX_66)){
           short n=(short)(*ptr &0xFFFF);
           thread.mem->write_virtual_mem(thread.Exx[7],2,(char*)&n);
           thread.Exx[6]+=2;
           thread.Exx[7]+=2;
        }else if (s->opcode->substr(0,s->opcode->size())=="movsd" && !(s->hde.flags & F_PREFIX_66)){
           dword n=*ptr;
           thread.mem->write_virtual_mem(thread.Exx[7],4,(char*)&n);
           thread.Exx[6]+=4;
           thread.Exx[7]+=4;                                           
        };
        //cout << "the result is = "<< (int*)thread.Exx[0]<< "\n";
        //system("PAUSE");
    };
};
//-----------------------------------------------------------------------------------------------------------------
//CMPS
int op_cmps(Thread& thread,ins_disasm* s){
    int rep=1;     //for repeat instructions
    bool repe=false;
    if (s->hde.flags & F_PREFIX_REP){
       rep=thread.Exx[1];            //ecx
       //thread.Exx[1]=0;              //set it to zero
    };
    if (s->hde.flags & F_PREFIX_REPX){
       repe=true;
    };
    //now we will loop the read instruction
    for (int i=0;i< rep;i++){
        //one byte
         dword* src=(dword*)thread.mem->read_virtual_mem(thread.Exx[6]);  //esi
         dword* dest=(dword*)thread.mem->read_virtual_mem(thread.Exx[7]);  //edi
         //cout << (int*)*dest<<"\n";
         dword result;
        if (s->opcode->substr(0,s->opcode->size())=="cmpsb"){
           result=(*src & 0xFF)-(*dest &0xFF);
           thread.Exx[1]--; 
           thread.Exx[6]+=1;
           thread.Exx[7]+=1;                                                
        }else if (s->opcode->substr(0,s->opcode->size())=="cmpsd" && (s->hde.flags & F_PREFIX_66)){
           result=(*src  & 0xFFFF- *dest & 0xFFFF );
           thread.Exx[1]--; 
           thread.Exx[6]+=2;
           thread.Exx[7]+=2;
        }else if (s->opcode->substr(0,s->opcode->size())=="cmpsd" && !(s->hde.flags & F_PREFIX_66)){
           result=*src -*dest;
           thread.Exx[1]--; 
           thread.Exx[6]+=4;
           thread.Exx[7]+=4;                                           
        };
        thread.updateflags(*dest,0,result,UPDATEFLAGS_SUB);
        //system("PAUSE");
        if (thread.EFlags & EFLG_ZF && repe==false)break;
        if (!(thread.EFlags & EFLG_ZF) && repe==true)break;
        //cout << "the result is = "<< (int*)thread.Exx[0]<< "\n";
        //system("PAUSE");
    };
};
//-----------------------------------------------------------------------------------------------------------------
//SCAS
int op_scas(Thread& thread,ins_disasm* s){
    int rep=1;     //for repeat instructions
    bool repe=false;
    if (s->hde.flags & F_PREFIX_REP){
       rep=thread.Exx[1];            //ecx
       //thread.Exx[1]=0;              //set it to zero
    };
    if (s->hde.flags & F_PREFIX_REPX){
       repe=true;
    };
    //now we will loop the read instruction
    for (int i=0;i< rep;i++){
        //one byte
         dword* src=(dword*)&thread.Exx[0];  //eax
         dword* dest=(dword*)thread.mem->read_virtual_mem(thread.Exx[7]);  //edi
         //cout << (int*)*dest<<"\n";
         dword result;
        if (s->opcode->substr(0,s->opcode->size())=="scasb"){
           result=(*src & 0xFF)-(*dest &0xFF);
           thread.Exx[1]--; 
           //thread.Exx[6]+=1;
           thread.Exx[7]+=1;                                                
        }else if (s->opcode->substr(0,s->opcode->size())=="scasd" && (s->hde.flags & F_PREFIX_66)){
           result=(*src  & 0xFFFF- *dest & 0xFFFF );
           thread.Exx[1]--; 
           //thread.Exx[6]+=2;
           thread.Exx[7]+=2;
        }else if (s->opcode->substr(0,s->opcode->size())=="scasd" && !(s->hde.flags & F_PREFIX_66)){
           result=*src -*dest;
           thread.Exx[1]--; 
           //thread.Exx[6]+=4;
           thread.Exx[7]+=4;                                           
        };
        thread.updateflags(*dest,0,result,UPDATEFLAGS_SUB);
        //cout<< (int*)result << "\n";
        //system("PAUSE");
        if (thread.EFlags & EFLG_ZF && repe==false)break;
        if (!(thread.EFlags & EFLG_ZF) && repe==true)break;
        //cout << "the result is = "<< (int*)thread.Exx[0]<< "\n";
        //system("PAUSE");
    };
};
